#include <iostream>
#include <cstdio>
#include <vector>
#include <string>
#include <cstring>
#include <cmath>
#include <cstdlib>
#include <algorithm>
using namespace std;


const int INF = (int)1e9 + 10;
const int maxn = 115;
int a[maxn][maxn];
int degIn[maxn];
bool used[maxn];
int ptr[maxn];
int dist[maxn];
int q[maxn];
const int inf = 1e5;



struct Edge
{
	int to, cap, flow, rid;
	Edge() : to(), cap(), flow(), rid() {}
	Edge(int _to, int _cap, int _rid) : to(_to), cap(_cap), flow(), rid(_rid) {}
};

vector <Edge> g[maxn];

void addEdge(int v, int to, int cap)
{
	g[v].push_back(Edge(to, cap, (int) g[to].size() ) );
	g[to].push_back(Edge(v, 0, (int) g[v].size() - 1) );
}


bool dfs(int v, int en, int flow)
{
	if (v == en)
		return flow;
	for (int &i = ptr[v]; i < (int) g[v].size(); i++)
	{
		if (g[v][i].flow == g[v][i].cap)
			continue;
		Edge e = g[v][i];
		if (dist[e.to] == dist[v] + 1)
		{
			int tmp = e.cap - e.flow;
			tmp = dfs(e.to, en, min(flow, tmp));
			if (tmp > 0)
			{
				g[v][i].flow += tmp;
				g[e.to][e.rid].flow -= tmp;
				return tmp;
			}
		}
	}
	return 0;
}

bool bfs(int s, int t)
{
	fill(dist, dist + maxn, INF);
	int topQ = 0;
	q[topQ++] = s;
	dist[s] = 0;
	for (int i = 0; i < topQ; i++)
	{
		int v = q[i];
		for (int k = 0; k < (int)g[v].size(); k++)
		{
			Edge e = g[v][k];
			if (e.cap - e.flow > 0 && dist[e.to] > dist[v] + 1)
			{
				dist[e.to] = dist[v] + 1;
				q[topQ++] = e.to;
			}
		}
	}
	return dist[t] != INF;
}

int findFlow(int s, int t)
{
	int ans = 0;
	while (bfs(s, t))
	{
		memset(ptr, 0, sizeof(ptr));
		int curFlow = 0;
		while (curFlow = dfs(s, t, INF))
		{
			ans += curFlow;
		}
	}
	return ans;
}


int n;
int cnt[maxn][maxn];

void addOne(int v, int nv, vector <int> &ans)
{
	if (a[v][nv] == n)
	{
		ans.push_back(nv);
		return;
	}
	addOne(v, a[v][nv], ans);
	addOne(a[v][nv], nv, ans);
}

int endAt[maxn];

void dfsAns(int v, vector <int> &ans)
{
	for (int &nv = endAt[v]; nv < n; nv++)
	{
		if (cnt[v][nv] == 0)
			continue;
		cnt[v][nv]--;
		addOne(v, nv, ans);
		dfsAns(nv, ans);
		break;
	}
}

int main()
{
	freopen("inspection.in", "r", stdin);
	freopen("inspection.out", "w", stdout);

	memset(a, -1, sizeof a);
	
	scanf("%d", &n);
	for (int i = 0; i < n; i++)
	{
		int k;
		scanf("%d", &k);
		for (int j = 0; j < k; j++)
		{
			int x;
			scanf("%d", &x);
			x--;
			cnt[i][x]++;
			a[i][x] = n;
			degIn[x]++;
			degIn[i]--;
		}
	}
	/*

	n = 100;
	for (int i = 0; i < n; i++)
	{
		if (i == n - 1)
			continue;
		int c = rand() % (n - i - 1);
		for (int s = i + 1; s < i + c; s++)
		{
			cnt[i][s]++;
			a[i][s] = n;
			degIn[s]++;
			degIn[i]--;
		}
	}
	*/

	for (int h = 0; h < n; h++)
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
			{
				if (a[i][h] != -1 && a[h][j] != -1 && a[i][j] == -1)
				{
					a[i][j] = h;
				}
			}
	int s = n;
	int t = n + 1;
	for (int i = 0; i < n; i++)
	{
		if (degIn[i] > 0)
		{
			addEdge(s, i, degIn[i] );
			for (int j = 0; j < n; j++)
			{
				if (degIn[j] < 0 && a[i][j] != -1)
				{
					addEdge(i, j, inf);
				}
			}
		}
		else if (degIn[i] < 0)
		{
			addEdge(i, t, -degIn[i] );
		}
	}
	findFlow(s, t);
	for (int i = 0; i < n; i++)
	{
		if (degIn[i] <= 0)
			continue;
		for (int j = 0; j < (int) g[i].size(); j++)
		{
			int nv = g[i][j].to;
			if (nv >= n)
				continue;
			degIn[i] -= g[i][j].flow;
			degIn[nv] += g[i][j].flow;
			cnt[i][nv] += g[i][j].flow;
		}
	}
	vector <vector <int> > answer;
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < -degIn[i]; j++)
		{
			vector <int> v;
			v.push_back(i);
			dfsAns(i, v);
			answer.push_back(v);
		}
	}
	printf("%d\n", (int) answer.size() );
	for (int i = 0; i < (int) answer.size(); i++)
	{
		for (int j = 0; j < (int) answer[i].size(); j++)
		{
			printf("%d ", answer[i][j] + 1);
		}
		printf("\n");
	}

	return 0;
}
